
###### cutoff 0.58
DEup <- c(670,812,561,234,1018,184,3773,553,351,3202,2901)
DEdown <- c(444,432,5,540,4741,171,4857,74,178,1232,726)

pdf(file="SFig2B.pdf",height=6,width=3.4)
par(mar=c(10,4,4,2))
bp <- barplot(DEup,ylim=c(-6000,6000),axes=F,col="lightblue",border=NA,space=0.5,main="DE gene number of naive path")
barplot(-DEdown,add=T,axes=F,col="red",border=NA,space=0.5)
axis(side=2,seq(-6000,6000,2000),abs(seq(-6000,6000,2000)),las=2)
# mtext(side=1,at=(1:11)*1.5-1.3,c("hiF-T","0d","2d","6d","8d","10d","12d","14d","20d","24d-dox","24d+dox"),line=1,las=2,cex=0.8)
# mtext(side=1,at=(1:10)*1.5-0.6,c("->","->","->","->","->","->","->","->","->","->"),line=1,las=1,cex=0.8)
mtext(side=1,at=bp,c("hiF-T -> 0d","0d -> 2d","2d -> 6d","6d -> 8d","8d -> 12d","12d -> 14d","14d -> 20d","20d -> 24d-dox","20d -> 24d+dox","24d+dox -> niPSC-T","24d-dox -> niPSC-T"),line=0.5,las=2,srt=45)
# text((1:11)*1.5-1,-7000,c("hiF-T -> 0d","0d -> 2d","2d -> 6d","6d -> 8d","8d -> 12d","12d -> 14d","14d -> 20d","20d -> 24d-dox","20d -> 24d+dox","24d+dox -> niPSC-T","24d-dox -> niPSC-T"),srt=45,,xpd = TRUE, pos = 3)
legend("topleft",c("Up-regulated","Down-regulated"),pch=15,box.lty=0,col=c("lightblue","red"))
dev.off()